package w83a.w83aBeans;

import java.sql.ResultSet;

import org.apache.commons.lang.StringUtils;

import w83a.util.jdbc.W83aDataBase;
import w83a.w83aDAO.w83aConstantesBD.W83aActasBD;
import w83a.w83aDAO.w83aConstantesBD.W83aBaseBeanBD;
import w83a.w83aDAO.w83aConstantesBD.W83aImpugnacionesBD;
import w83a.w83aDAO.w83aConstantesBD.W83aPreavisosBD;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bImpugnacionesBean.
 */
public class W83aImpugnacionesBean extends W83aBaseBean implements W83aBaseBeanBD{
	
	
	/** The Constant serialVersionUID. */
	private static final long	serialVersionUID	= 1L;
	
	/** The num_impugnacion. */
	private String num_impugnacion;
	
	/** The fecha_impugnacion. */
	private String fecha_impugnacion;
	
	/** The sindicatos. */
	private String sindicatos;
	
	/** The sindicatos. */
	private String impugnante;
	
	/** The dni_arbitro. */
	private String dni_arbitro;
	
	/** The nombre_arbitro. */
	private String nombre_arbitro;
	
	/** The num_laudo. */
	private String num_laudo;
	
	/** The fech_laudo. */
	private String fech_laudo;
	
	/** The fech_envio_juzgado. */
	private String fech_envio_juzgado;
	
	/** The fech_sentencia. */
	private String fech_sentencia;
	
	/** The fech_baja_desest. */
	private String fech_baja_desest;
	
	/** The resultado. */
	private String resultado;
	private String resultadoDesc;
	
	/** The tipo. */
	private String tipo;
		
	
	
	public String getResultadoDesc() {
		return resultadoDesc;
	}

	public void setResultadoDesc(String resultadoDesc) {
		this.resultadoDesc = resultadoDesc;
	}

	public String getImpugnante() {
		return impugnante;
	}

	public void setImpugnante(String impugnante) {
		this.impugnante = impugnante;
	}

	/**
	 * Gets the tipo.
	 * 
	 * @return the tipo
	 */
	public String getTipo() {
		return this.tipo;
	}
	
	/**
	 * Sets the tipo.
	 * 
	 * @param tipo the new tipo
	 */
	public void setTipo(String tipo) {
		this.tipo = tipo;
	}
	
	/**
	 * Gets the num_impugnacion.
	 * 
	 * @return the num_impugnacion
	 */
	public String getNum_impugnacion() {
		return this.num_impugnacion;
	}
	
	/**
	 * Sets the num_impugnacion.
	 * 
	 * @param num_impugnacion the new num_impugnacion
	 */
	public void setNum_impugnacion(String num_impugnacion) {
		this.num_impugnacion = num_impugnacion;
	}
	
	/**
	 * Gets the fecha_impugnacion.
	 * 
	 * @return the fecha_impugnacion
	 */
	public String getFecha_impugnacion() {
		return this.fecha_impugnacion;
	}
	
	/**
	 * Sets the fecha_impugnacion.
	 * 
	 * @param fecha_impugnacion the new fecha_impugnacion
	 */
	public void setFecha_impugnacion(String fecha_impugnacion) {
		this.fecha_impugnacion = fecha_impugnacion;
	}
	
	/**
	 * Gets the sindicatos.
	 * 
	 * @return the sindicatos
	 */
	public String getSindicatos() {
		return this.sindicatos;
	}
	
	/**
	 * Sets the sindicatos.
	 * 
	 * @param sindicatos the new sindicatos
	 */
	public void setSindicatos(String sindicatos) {
		this.sindicatos = sindicatos;
	}
	
	/**
	 * Gets the dni_arbitro.
	 * 
	 * @return the dni_arbitro
	 */
	public String getDni_arbitro() {
		return this.dni_arbitro;
	}
	
	/**
	 * Sets the dni_arbitro.
	 * 
	 * @param dni_arbitro the new dni_arbitro
	 */
	public void setDni_arbitro(String dni_arbitro) {
		this.dni_arbitro = dni_arbitro;
	}
	
	/**
	 * Gets the nombre_arbitro.
	 * 
	 * @return the nombre_arbitro
	 */
	public String getNombre_arbitro() {
		return this.nombre_arbitro;
	}
	
	/**
	 * Sets the nombre_arbitro.
	 * 
	 * @param nombre_arbitro the new nombre_arbitro
	 */
	public void setNombre_arbitro(String nombre_arbitro) {
		this.nombre_arbitro = nombre_arbitro;
	}
	
	/**
	 * Gets the num_laudo.
	 * 
	 * @return the num_laudo
	 */
	public String getNum_laudo() {
		return this.num_laudo;
	}
	
	/**
	 * Sets the num_laudo.
	 * 
	 * @param num_laudo the new num_laudo
	 */
	public void setNum_laudo(String num_laudo) {
		this.num_laudo = num_laudo;
	}
	
	/**
	 * Gets the fech_laudo.
	 * 
	 * @return the fech_laudo
	 */
	public String getFech_laudo() {
		return this.fech_laudo;
	}
	
	/**
	 * Sets the fech_laudo.
	 * 
	 * @param fech_laudo the new fech_laudo
	 */
	public void setFech_laudo(String fech_laudo) {
		this.fech_laudo = fech_laudo;
	}
	
	/**
	 * Gets the fech_envio_juzgado.
	 * 
	 * @return the fech_envio_juzgado
	 */
	public String getFech_envio_juzgado() {
		return this.fech_envio_juzgado;
	}
	
	/**
	 * Sets the fech_envio_juzgado.
	 * 
	 * @param fech_envio_juzgado the new fech_envio_juzgado
	 */
	public void setFech_envio_juzgado(String fech_envio_juzgado) {
		this.fech_envio_juzgado = fech_envio_juzgado;
	}
	
	/**
	 * Gets the fech_sentencia.
	 * 
	 * @return the fech_sentencia
	 */
	public String getFech_sentencia() {
		return this.fech_sentencia;
	}
	
	/**
	 * Sets the fech_sentencia.
	 * 
	 * @param fech_sentencia the new fech_sentencia
	 */
	public void setFech_sentencia(String fech_sentencia) {
		this.fech_sentencia = fech_sentencia;
	}
	
	/**
	 * Gets the fech_baja_desest.
	 * 
	 * @return the fech_baja_desest
	 */
	public String getFech_baja_desest() {
		return this.fech_baja_desest;
	}
	
	/**
	 * Sets the fech_baja_desest.
	 * 
	 * @param fech_baja_desest the new fech_baja_desest
	 */
	public void setFech_baja_desest(String fech_baja_desest) {
		this.fech_baja_desest = fech_baja_desest;
	}
	
	
	
	public W83aImpugnacionesBean() {
		super();
		// TODO Auto-generated constructor stub
	}

	public W83aImpugnacionesBean(W83aImpugnacionesBean impugnacion) {
		super();
		this.num_impugnacion = impugnacion.num_impugnacion;
		this.fecha_impugnacion = impugnacion.fecha_impugnacion;
		this.sindicatos = impugnacion.sindicatos;
		this.impugnante = impugnacion.impugnante;
		this.dni_arbitro = impugnacion.dni_arbitro;
		this.nombre_arbitro = impugnacion.nombre_arbitro;
		this.num_laudo = impugnacion.num_laudo;
		this.fech_laudo = impugnacion.fech_laudo;
		this.fech_envio_juzgado = impugnacion.fech_envio_juzgado;
		this.fech_sentencia = impugnacion.fech_sentencia;
		this.fech_baja_desest = impugnacion.fech_baja_desest;
		this.resultado = impugnacion.resultado;
		this.resultadoDesc = impugnacion.resultadoDesc;
		this.tipo = impugnacion.tipo;
	}

	/**
	 * Row to bean.
	 * 
	 * @param o the o
	 * @param otrosValores the otros valores
	 * @return the object
	 * @throws Exception the exception
	 */
	public Object rowToBean(Object o, Object otrosValores) throws Exception {
		ResultSet rs = (ResultSet)o;//NOPMD
		this.num_impugnacion = W83aDataBase.getStringFromRS(rs, W83aPreavisosBD.num_impugnacion);
		
		this.sindicatos = W83aDataBase.getStringFromRS(rs, W83aPreavisosBD.desc_sindicatos);
		this.dni_arbitro = W83aDataBase.getStringFromRS(rs, W83aPreavisosBD.dni_arbitro);
		this.nombre_arbitro = W83aDataBase.getStringFromRS(rs, W83aPreavisosBD.nombre_arbitro);
		this.num_laudo = W83aDataBase.getStringFromRS(rs, W83aPreavisosBD.num_laudo);
		this.resultado = W83aDataBase.getStringFromRS(rs, W83aPreavisosBD.resultado);
		this.tipo=W83aDataBase.getStringFromRS(rs, W83aPreavisosBD.desc_tipo);
		if("acta".equals(otrosValores)){
			this.fecha_impugnacion=W83aDataBase.getStringFromRS(rs, W83aActasBD.imp_fecha);
			this.fech_laudo=W83aDataBase.getStringFromRS(rs, W83aActasBD.imp_fechaLaudo);
			this.fech_envio_juzgado=W83aDataBase.getStringFromRS(rs, W83aActasBD.imp_fechaEnvioJuzgado);
			this.fech_sentencia=W83aDataBase.getStringFromRS(rs, W83aActasBD.imp_fechaSentencia);
			this.fech_baja_desest=W83aDataBase.getStringFromRS(rs, W83aActasBD.imp_fechaBajaDesestimiento);
			this.impugnante = W83aDataBase.getStringFromRS(rs, W83aActasBD.imp_nombreImpugnante);
			this.sindicatos = W83aDataBase.getStringFromRS(rs, W83aActasBD.imp_sindicatos);
			this.dni_arbitro = W83aDataBase.getStringFromRS(rs, W83aActasBD.imp_dni);
			this.nombre_arbitro = W83aDataBase.getStringFromRS(rs, W83aActasBD.imp_nombre);
			this.num_laudo = W83aDataBase.getStringFromRS(rs, W83aActasBD.imp_numLaudo);
			this.resultado = W83aDataBase.getStringFromRS(rs, W83aActasBD.imp_resultadoLaudo);
			this.resultadoDesc = W83aDataBase.getStringFromRS(rs, W83aImpugnacionesBD.descResultadoLaudo);
			this.tipo=W83aDataBase.getStringFromRS(rs, W83aActasBD.imp_tipo);
		}
		else{
			String numImpugnacionCompleto = W83aDataBase.getStringFromRS(rs, W83aPreavisosBD.num_impugnacion_completo);
			if(StringUtils.isNotEmpty(numImpugnacionCompleto)){
				this.num_impugnacion = numImpugnacionCompleto;
			}

			this.fecha_impugnacion=W83aDataBase.getStringFromRS(rs, W83aPreavisosBD.fech_impugnacion);
			this.fech_laudo=W83aDataBase.getStringFromRS(rs, W83aPreavisosBD.fech_laudo);
			this.fech_envio_juzgado=W83aDataBase.getStringFromRS(rs, W83aPreavisosBD.fech_envio_juzgado);
			this.fech_sentencia=W83aDataBase.getStringFromRS(rs, W83aPreavisosBD.fech_sentencia);
			this.fech_baja_desest=W83aDataBase.getStringFromRS(rs, W83aPreavisosBD.fech_baja_desestimiento);
			this.impugnante = W83aDataBase.getStringFromRS(rs, W83aPreavisosBD.nombreImpugnante);
			
			this.num_laudo = W83aDataBase.getStringFromRS(rs, W83aPreavisosBD.num_laudocompleto);
			
		}
		
		

		return this;
	}
	
	/**
	 * Gets the resultado.
	 * 
	 * @return the resultado
	 */
	public String getResultado() {
		return this.resultado;
	}
	
	/**
	 * Sets the resultado.
	 * 
	 * @param resultado the new resultado
	 */
	public void setResultado(String resultado) {
		this.resultado = resultado;
	}
	
}
